#!/bin/sh

export IFS="
"

rm files.txt
ls -al *\[small\]*
#rm *\[small\]*

for file in *.jpg; do
	basename=$(basename $file .jpg)
	echo ${basename}
	djpeg -pnm -scale 1/8 "${file}" | cjpeg -optimize -progressive > "${basename} [small]".jpg
	echo "${file}	${basename} [small].jpg" >> files.txt
done

awk -f makepicshtml.awk < files.txt > pics.html
